module.exports = function(sequelize, DataTypes) {
    return sequelize.define('LOG', {
            id: { type: DataTypes.INTEGER, primaryKey: true , autoIncrement: true },
            user_id: { type: DataTypes.INTEGER, allowNull: false },
            method: {type: DataTypes.TEXT, allowNull: true},
            request_json: {type: DataTypes.TEXT, allowNull: true},
            response_json: {type: DataTypes.TEXT, allowNull: true},
            requested_at: {type: DataTypes.DATE, allowNull: false},
            errors: {type: DataTypes.TEXT, allowNull: true}
        },
    {
        timestamps: false,
        underscored: true,
        freezeTableName: true,
        tableName: 'logs'
    });
}